function Y=interpLagrange(x,y,t)
%Interpolacija Lagranzovim interpolacionim polinomom.
n=length(x);
%vektori koji se koriste za izracunavanje interpolacionog polinoma stepena
%n-2
x1=x(1,2:n-1);
y1=y(1,2:n-1);
%izracunavanje koeficijenata Lagranzovog interpolacionog polinoma stepena
%n-2.Vektor A1 predstavlja koeficijente Lagranzovog interpolacionog
%polinoma stepena n-2
A1=zeros(n-2,1);
%br1 je broj potrebnih racunskih operacija za izracunavanje interpolacionog
%polinoma stepena n-2
br1=0;
%prolazimo kroz sve cvorove interpolacije
for i=1:n-2
    %p1 je polinom koji ima nule u x2,...xi-1,xi+1,...xn-1
    p1=poly(x1(find([1:n-2]~=i)))';
    %na Lagranzov interpolacioni polinom se dodaje p1*y1(i)/p1(xi)
    A1=A1+p1*y1(i)/polyval(p1,x1(i));
    br1=br1+3;
end
disp('Broj potrebnih racunskih operacija za izracunavanje');
disp('Lagranzovog interpolacionog polinoma stepena n-2 je:');
br1
disp('Lagranzovim interpolacionim polinomom stepena n-2');
disp('resenje je:');
Y1=polyval(A1,t)
%izracunavanje koeficijenata Lagranzovog interpolacionog polinoma stepena
%n.Vektor A predstavlja koeficijente Lagranzovog interpolacionog
%polinoma stepena n
A=zeros(n,1);
%br je broj potrebnih racunskih operacija za izracunavanje interpolacionog
%polinoma stepena n
br=0;
%prolazimo kroz sve cvorove interpolacije
for i=1:n
    %p je polinom koji ima nule u x1,...xi-1,xi+1,...xn
    p=poly(x(find([1:n]~=i)))';
    %na Lagranzov interpolacioni polinom se dodaje p*y1(i)/p(xi)
    A=A+p*y(i)/polyval(p,x(i));
    br=br+3;
end
disp('Broj potrebnih racunskih operacija za izracunavanje');
disp('Lagranzovog interpolacionog polinoma stepena n je:');
br
Y=polyval(A,t);

if br>br1
    disp('Zakljucujemo da je zainterpolaciju Lagranzovim polinomom'); 
    disp('stepena n potrebno vise racunskih operacija i to');     
else 
    disp('Zakljucujemo da je za interpolaciju Lagranzovim polinomom')
    disp('stepena n-2 potrebno vise racunskih operacija i to');
end
br-br1
disp('racunskih operacija');




